<?php
include("Archive/Tar.php");

# CONFIGURATIONS
$source_dir = "/home/website/public_html/stuff/tools/tmp";  // Extraction path
$target_dir = "/home/website/public_html";  // web root
$extract_dir = "/home/website/public_html/stuff/tools/tmp"; // Can be the same as $source_dir
$archive_file_name = $_GET['afn'];  // The archive file name
$archive_dir_name = isset($_GET['adn']) ? $_GET['adn'] : $_GET['afn'];  // The folder name in archive file 
$skip_dir = $target_dir."/sites";
$drupal_url = 'http://ftp.drupal.org/files/projects';
$drupal_file = $archive_file_name.'.tar.gz';

# DOWNLOAD DRUPAL TARBALL
$fp = fopen ($source_dir.'/'.$drupal_file, 'w+');//This is the file where we save the information
$ch = curl_init($drupal_url.'/'.$drupal_file);//Here is the file we are downloading
curl_setopt($ch, CURLOPT_TIMEOUT, 50);
curl_setopt($ch, CURLOPT_FILE, $fp);
curl_exec($ch);
curl_close($ch);
fclose($fp);

echo "Download finished.<br/>";

# EXTRACT TARBALL
$tar = new Archive_Tar($source_dir."/".$drupal_file);
$tar->extract($extract_dir);

echo "Extract complete.<br/>";

# MOVE EXTRACTED FILES
recursive_move($extract_dir.'/'.$archive_dir_name, $target_dir, false);

echo "Move complete.<br/>";

# DELETE TARBALL
unlink($source_dir.'/'.$drupal_file);

echo "Archive deleted.<br/>";

# FUNCTION FOR MOVING FILES
function recursive_move($dirsource, $dirdest, $include_parent=true){
  global $skip_dir;
  
  // recursive function to copy
  // all subdirectories and contents:
  if(is_dir($dirsource))$dir_handle=opendir($dirsource);
  $dirname = "";
  if ($include_parent == true) {
    $dirname = substr($dirsource,strrpos($dirsource,"/")+1);
  }

  if ($dirname != "") {
    if (!is_dir($dirdest."/".$dirname)) {
      if (strstr($dirdest."/".$dirname, $skip_dir) == false) {
        mkdir($dirdest."/".$dirname, 0755);
      }
    }
  }
  while($file=readdir($dir_handle)){
    if($file!="." && $file!=".."){
      if(!is_dir($dirsource."/".$file)){
        // Skip /sites folder and .htaccess file 
        if (strstr($dirdest."/".$dirname, $skip_dir) == false && $file != ".htaccess") {
          copy ($dirsource."/".$file, $dirdest."/".($dirname!= "" ? $dirname."/" : "").$file);
        }
        unlink($dirsource."/".$file);
      }
      else{
        $dirdest1 = $dirdest.($dirname!= "" ? "/".$dirname : "");
        recursive_move($dirsource."/".$file, $dirdest1, true);
      }
    }
  }
  
  closedir($dir_handle);
  rmdir($dirsource);
}
